/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ShulkerBoxItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.item.CapabilityStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.StackStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageContentsTooltip;

public class ShulkerBoxItem
extends StorageBlockItem
implements IStashStorageItem {
    public ShulkerBoxItem(Block block) {
        super(block, new Item.Properties().m_41487_(1));
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){
            private final NonNullLazy<BlockEntityWithoutLevelRenderer> ister = NonNullLazy.of(() -> new ShulkerBoxItemRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.ister.get();
            }
        });
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (flagIn == TooltipFlag.Default.ADVANCED) {
            stack.getCapability(CapabilityStorageWrapper.getCapabilityInstance()).ifPresent(w -> w.getContentsUuid().ifPresent(uuid -> tooltip.add((Component)new TextComponent("UUID: " + uuid).m_130940_(ChatFormatting.DARK_GRAY))));
        }
        if (!Screen.m_96638_()) {
            tooltip.add((Component)new TranslatableComponent(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".press_for_contents", new Object[]{new TranslatableComponent(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".shift").m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        AtomicReference<Object> ret = new AtomicReference<Object>(null);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft mc = Minecraft.m_91087_();
            if (Screen.m_96638_() || mc.f_91074_ != null && !mc.f_91074_.f_36096_.m_142621_().m_41619_()) {
                ret.set(new StorageContentsTooltip(stack));
            }
        });
        return Optional.ofNullable(ret.get());
    }

    public boolean m_142095_() {
        return false;
    }

    public void m_142023_(ItemEntity itemEntity) {
        Level level = itemEntity.f_19853_;
        if (level.f_46443_) {
            return;
        }
        ItemStack itemstack = itemEntity.m_32055_();
        itemstack.getCapability(CapabilityStorageWrapper.getCapabilityInstance()).ifPresent(storageWrapper -> {
            InventoryHelper.dropItems((ItemStackHandler)storageWrapper.getInventoryHandler(), (Level)level, (double)itemEntity.m_20185_(), (double)itemEntity.m_20186_(), (double)itemEntity.m_20189_());
            InventoryHelper.dropItems((ItemStackHandler)storageWrapper.getUpgradeHandler(), (Level)level, (double)itemEntity.m_20185_(), (double)itemEntity.m_20186_(), (double)itemEntity.m_20189_());
        });
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){
            private IStorageWrapper wrapper = null;

            @Nonnull
            public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
                if (stack.m_41613_() == 1 && cap == CapabilityStorageWrapper.getCapabilityInstance()) {
                    this.initWrapper();
                    return LazyOptional.of(() -> this.wrapper).cast();
                }
                return LazyOptional.empty();
            }

            private void initWrapper() {
                if (this.wrapper == null) {
                    UUID uuid = NBTHelper.getUniqueId((ItemStack)stack, (String)"uuid").orElse(null);
                    StackStorageWrapper storageWrapper = new StackStorageWrapper(stack){

                        @Override
                        protected boolean isAllowedInStorage(ItemStack stack) {
                            Block block = Block.m_49814_((Item)stack.m_41720_());
                            return !(block instanceof net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock) && !(block instanceof ShulkerBoxBlock);
                        }
                    };
                    if (uuid != null) {
                        CompoundTag compoundtag = ItemContentsStorage.get().getOrCreateStorageContents(uuid).m_128469_("storageWrapper");
                        storageWrapper.load(compoundtag);
                        storageWrapper.setContentsUuid(uuid);
                    }
                    this.wrapper = storageWrapper;
                }
            }
        };
    }

    public Optional<TooltipComponent> getInventoryTooltip(ItemStack stack) {
        return Optional.of(new StorageContentsTooltip(stack));
    }

    public ItemStack stash(ItemStack storageStack, ItemStack stack) {
        return storageStack.getCapability(CapabilityStorageWrapper.getCapabilityInstance()).map(wrapper -> wrapper.getInventoryForUpgradeProcessing().insertItem(stack, false)).orElse(stack);
    }

    public boolean isItemStashable(ItemStack storageStack, ItemStack stack) {
        return storageStack.getCapability(CapabilityStorageWrapper.getCapabilityInstance()).map(wrapper -> wrapper.getInventoryForUpgradeProcessing().isItemValid(0, stack)).orElse(false);
    }

    public void setNumberOfInventorySlots(ItemStack shulkerBoxStack, int numberOfInventorySlots) {
        NBTHelper.putInt((CompoundTag)shulkerBoxStack.m_41784_(), (String)"numberOfInventorySlots", (int)numberOfInventorySlots);
    }

    public int getNumberOfInventorySlots(ItemStack shulkerBoxStack) {
        int defaultNumberOfInventorySlots = shulkerBoxStack.getCapability(CapabilityStorageWrapper.getCapabilityInstance()).map(StorageWrapper::getDefaultNumberOfInventorySlots).orElse(1);
        return NBTHelper.getInt((ItemStack)shulkerBoxStack, (String)"numberOfInventorySlots").map(inventorySlots -> Math.max(inventorySlots, defaultNumberOfInventorySlots)).orElse(defaultNumberOfInventorySlots);
    }

    public int getNumberOfUpgradeSlots(ItemStack shulkerBoxStack) {
        int defaultNumberOfUpgradeSlots = shulkerBoxStack.getCapability(CapabilityStorageWrapper.getCapabilityInstance()).map(StorageWrapper::getDefaultNumberOfUpgradeSlots).orElse(1);
        return NBTHelper.getInt((ItemStack)shulkerBoxStack, (String)"numberOfUpgradeSlots").map(numberOfUpgradeSlots -> Math.max(numberOfUpgradeSlots, defaultNumberOfUpgradeSlots)).orElse(defaultNumberOfUpgradeSlots);
    }

    public void setNumberOfUpgradeSlots(ItemStack shulkerBoxStack, int numberOfUpgradeSlots) {
        NBTHelper.putInt((CompoundTag)shulkerBoxStack.m_41784_(), (String)"numberOfUpgradeSlots", (int)numberOfUpgradeSlots);
    }
}

